/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.AboutDialog;
import ibm.nways.jdm.AxisCanvas;
import ibm.nways.jdm.Banner;
import ibm.nways.jdm.BorderedPanel;
import ibm.nways.jdm.DestinationPanel;
import ibm.nways.jdm.FlyOverPanel;
import ibm.nways.jdm.Footer;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelper;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.GraphicPanelProducer;
import ibm.nways.jdm.HasJmaPopup;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.JdmLayoutDialog;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.MessageDialog;
import ibm.nways.jdm.NavMiscCustomization;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.NilDestination;
import ibm.nways.jdm.eui.PropertyBook;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class BrowserApplet
extends Applet
implements NavigationBrowserEventListener,
GraphicHandler,
HasJmaPopup {
    private Panel navPanel;
    private BorderedPanel borderedGraphicPanel;
    private Panel jdmDestPanel;
    private Banner banner;
    private Footer footer;
    private NavigationPoint navTree;
    private DestinationPanel destPanel;
    private URL imageBase;
    private URL audioBase;
    private URL helpBase;
    private Color backgroundColor;
    private Color foregroundColor;
    private Color axisColor;
    private Color selListBackColor;
    private Color selListForeColor;
    private Color buttonForeground;
    private Color buttonBackground;
    private boolean isApplication = false;
    public static boolean DebugSwitch;
    private NavigationBrowser navBrowser;
    private JdmLayoutDialog layoutDialog;
    private GraphicHelper graphicHelper;
    private Properties properties;
    private static ResourceBundle myResources;
    NavigateToThread navThread;
    private boolean isNetscape = false;
    private static final String PropertiesFile = "properties/BrowserApplet.txt";
    private static final Color DefaultBackgroundColor;
    private static final Color DefaultForegroundColor;
    private static final Color DefaultAxisColor;
    private static final Color DefaultSelListBackColor;
    private static final Color DefaultSelListForeColor;
    private static final Color DefaultButtonForeground;
    private static final Color DefaultButtonBackground;
    private static final String WebBrowserKey = "webBrowser.path";
    private static final String ImageBaseKey = "imagebase";
    private static final String AudioBaseKey = "audiobase";
    private static final String HelpBaseKey = "helpbase";
    private static final String NavigateToKey = "navigateTo";
    private static final String NavigationContextKey = "navigationContext";
    private static final String LayoutSchemeKey = "layout.scheme";
    private static final String LayoutFractsKey = "layout.fractions";
    private static final String DebugKey = "debug";
    private static final String BannerLeft = "/ibm/nways/jdm/BannerLeft.gif";
    private static final String BannerFill = "/ibm/nways/jdm/BannerFill.gif";
    private static final String BannerRight = "/ibm/nways/jdm/BannerRight.gif";
    private static final String BackgroundColorParmName = "backgroundColor";
    private static final String ForegroundColorParmName = "foregroundColor";
    private static final String AxisColorParmName = "axisColor";
    private static final String SelListBackParmName = "pbook.selectionListBackground";
    private static final String SelListForeParmName = "pbook.selectionListForeground";
    private static final String ButtonForeParmName = "pbook.buttonForeground";
    private static final String ButtonBackParmName = "pbook.buttonBackground";
    private static final String BrowserPopupName = "BrowserAppletPopup";
    private static Dimension defaultSize;
    private static String AboutTextPropName;
    private static String AboutIconPropName;
    private static String AboutTitlePropName;
    private static String AboutWidthPropName;
    private static String AboutHeightPropName;
    private FlyOverPanel flyOver;
    public int flyOverDelay = 400;
    FlyOverTimer flyOverTimer;

    public BrowserApplet() {
        if (System.getProperty("java.vendor").indexOf("Netscape") >= 0) {
            this.isNetscape = true;
            return;
        }
        this.isNetscape = false;
    }

    public boolean isNetscape() {
        return this.isNetscape;
    }

    public synchronized void init() {
        this.flyOver = new FlyOverPanel();
        this.flyOver.setVisible(false);
        this.add((Component)this.flyOver, 0);
        long l = System.currentTimeMillis();
        this.checkDebugSwitch();
        System.out.println("CodeBase: " + this.getCodeBase());
        System.out.println("DocumentBase: " + this.getDocumentBase());
        try {
            URL uRL = new URL(this.getDocumentBase(), PropertiesFile);
            this.properties = new Properties();
            this.properties.load(uRL.openStream());
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.getMessage());
            exception.printStackTrace();
        }
        this.setColors();
        this.setLayout(this.setupLayoutManager());
        this.banner = new Banner(this.imageFrom(this, BannerLeft), this.imageFrom(this, BannerFill), this.imageFrom(this, BannerRight));
        this.add("Banner", this.banner);
        this.footer = new Footer();
        this.add("Footer", this.footer);
        this.doLayout();
        long l2 = System.currentTimeMillis();
        System.out.println("Banner initialized in " + (l2 - l) + " millis");
        this.postBannerInit();
        this.navTree = this.createNavTreeRoot();
        this.setupNavigationPanel();
        this.destPanel = new NilDestination();
        this.jdmDestPanel = new BorderedPanel(this.destPanel.getComponent(), 3, 3, this.getBackground());
        this.add("DestPanel", this.jdmDestPanel);
        this.invalidate();
        this.validate();
        this.setupGraphicPanel();
        AxisCanvas axisCanvas = new AxisCanvas(this.axisColor);
        this.add("Axis1", axisCanvas);
        AxisCanvas axisCanvas2 = new AxisCanvas(this.axisColor);
        this.add("Axis2", axisCanvas2);
        this.invalidate();
        this.validate();
        this.createRestOfNavTree();
    }

    public void refreshAll() {
        this.removeNavigationPanel();
        this.removeGraphicPanel();
        this.changeDestPanel(new NilDestination());
        this.displayMsg(myResources.getString("RedrawConfig"));
        NavigationPoint navigationPoint = this.navTree;
        this.navTree = this.createNavTreeRoot();
        this.resetNavigationPanel();
        this.resetGraphicPanel();
        this.createRestOfNavTree();
        if (navigationPoint != null) {
            navigationPoint.dispose();
        }
    }

    protected Footer getFooter() {
        return this.footer;
    }

    public void displayMsg(String string) {
        this.footer.displayMsg(string);
    }

    protected void postBannerInit() {
    }

    private void setColors() {
        JmaColors.background = this.backgroundColor = this.getColorForParm(BackgroundColorParmName, DefaultBackgroundColor);
        this.setBackground(this.backgroundColor);
        JmaColors.textText = this.foregroundColor = this.getColorForParm(ForegroundColorParmName, DefaultForegroundColor);
        this.setForeground(this.foregroundColor);
        this.axisColor = DefaultAxisColor;
        PropertyBook.selListBackColor = this.selListBackColor = this.getColorForParm(SelListBackParmName, DefaultSelListBackColor);
        PropertyBook.selListForeColor = this.selListForeColor = this.getColorForParm(SelListForeParmName, DefaultSelListForeColor);
        PropertyBook.buttonForeground = this.buttonForeground = this.getColorForParm(ButtonForeParmName, DefaultButtonForeground);
        PropertyBook.buttonBackground = this.buttonBackground = this.getColorForParm(ButtonBackParmName, DefaultButtonBackground);
    }

    private JdmLayout setupLayoutManager() {
        String string;
        JdmLayout jdmLayout = new JdmLayout();
        String string2 = this.getParameter(LayoutSchemeKey);
        if (string2 != null) {
            try {
                int n = Integer.parseInt(string2, 10);
                jdmLayout.setScheme(n);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Bad layout.scheme parm(" + numberFormatException.toString() + ")");
            }
        }
        if ((string = this.getParameter(LayoutFractsKey)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n = 0;
            while (n < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    System.out.println("Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    bl = false;
                }
                ++n;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        return jdmLayout;
    }

    protected abstract NavigationPoint createNavTreeRoot();

    public void setFlyOverDelay(int n) {
        this.flyOverDelay = n;
    }

    private void createRestOfNavTree() {
        CreateRestOfNavTreeThread createRestOfNavTreeThread = new CreateRestOfNavTreeThread();
        createRestOfNavTreeThread.start();
    }

    protected void setNavigationPopupEnabled(boolean bl) {
        if (this.navBrowser != null) {
            this.navBrowser.setPopupEnabled(bl);
        }
    }

    private void navigateToInitialDest() {
        NavigationPoint navigationPoint;
        String string = this.getParameter(NavigateToKey);
        if (string != null && (navigationPoint = this.getNavigationTree().findId(string)) != null) {
            String string2 = this.getParameter(NavigationContextKey);
            if (string2 != null) {
                NavMiscCustomization.setProperty(navigationPoint.getNavContext(), string2);
            }
            this.navPointSelected(navigationPoint);
        }
    }

    protected synchronized void getRestOfNavTree() {
    }

    public URL getImageBase() {
        block3: {
            if (this.imageBase != null) break block3;
            String string = this.getParameter(ImageBaseKey);
            if (string == null) {
                string = "images";
            }
            try {
                this.imageBase = new URL(this.getDocumentBase(), String.valueOf(string) + "/");
                System.out.println("imagebase=" + this.imageBase.toString());
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("ImageBase URL exception: " + malformedURLException.getMessage());
            }
        }
        return this.imageBase;
    }

    public URL getAudioBase() {
        block3: {
            if (this.audioBase != null) break block3;
            String string = this.getParameter(AudioBaseKey);
            if (string == null) {
                string = "audio";
            }
            try {
                this.audioBase = new URL(this.getDocumentBase(), String.valueOf(string) + "/");
                System.out.println("audiobase=" + this.audioBase.toString());
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("AudioBase URL exception: " + malformedURLException.getMessage());
            }
        }
        return this.audioBase;
    }

    public URL getHelpBase() {
        block3: {
            if (this.helpBase != null) break block3;
            String string = this.getParameter(HelpBaseKey);
            if (string == null) {
                string = "help";
            }
            try {
                this.helpBase = new URL(this.getDocumentBase(), String.valueOf(string) + "/");
                System.out.println("helpbase=" + this.helpBase.toString());
            }
            catch (MalformedURLException malformedURLException) {
                System.out.println("HelpBase URL exception: " + malformedURLException.getMessage());
            }
        }
        return this.helpBase;
    }

    public Frame getFrame() {
        Frame frame = null;
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                frame = (Frame)container;
                break;
            }
            container = container.getParent();
        }
        return frame;
    }

    public Color getColorForParm(String string, Color color) {
        Color color2;
        block2: {
            color2 = color;
            String string2 = this.getParameter(string);
            if (string2 == null) break block2;
            try {
                int n = Integer.decode(string2);
                color2 = new Color(n);
            }
            catch (Exception exception) {
                System.out.println("Bad value for property " + string);
            }
        }
        return color2;
    }

    public Image imageFrom(Class clazz, String string) {
        Image image = null;
        MediaTracker mediaTracker = new MediaTracker(this);
        try {
            URL uRL = this.createUrlFor(clazz, string);
            image = this.getImage(uRL);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
            if (mediaTracker.isErrorID(0)) {
                System.out.println("Errors:" + mediaTracker.getErrorsID(0)[0]);
            }
        }
        catch (Exception exception) {
            System.out.println("Graphic image URL exception:" + exception.getMessage());
            exception.printStackTrace();
        }
        return image;
    }

    public Image imageFrom(Object object, String string) {
        return this.imageFrom(object.getClass(), string);
    }

    private URL createUrlFor(Class clazz, String string) throws MalformedURLException {
        URL uRL = null;
        if (this.isNetscape()) {
            String string2;
            if (string.charAt(0) == '/') {
                string2 = string.substring(1);
            } else {
                String string3 = clazz.getName();
                int n = string3.lastIndexOf(46);
                string2 = String.valueOf(string3.substring(0, n + 1).replace('.', '/')) + string;
            }
            uRL = new URL(this.getCodeBase(), string2);
        } else {
            uRL = clazz.getResource(string);
        }
        return uRL;
    }

    public NavigationPoint getNavigationTree() {
        return this.navTree;
    }

    public NavigationBrowser getNavigationBrowser() {
        return this.navBrowser;
    }

    private void setupNavigationPanel() {
        this.navBrowser = new NavigationBrowser(this.navTree, this, this);
        this.setNavigationPopupEnabled(false);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.add(this.navBrowser);
        this.navPanel = new BorderedPanel(scrollPane, 3, 3, this.getBackground());
        this.navPanel.doLayout();
        this.navPanel.invalidate();
        this.add("NavTree", this.navPanel);
        this.doLayout();
    }

    public void removeNavigationPanel() {
        if (this.navPanel != null) {
            this.remove(this.navPanel);
        }
    }

    public void resetNavigationPanel() {
        this.removeNavigationPanel();
        this.setupNavigationPanel();
        this.invalidate();
        this.validate();
    }

    private void setupGraphicPanel() {
        GraphicPanel graphicPanel;
        GraphicPanelProducer graphicPanelProducer;
        NavigationDestination navigationDestination;
        if (this.navTree != null && (navigationDestination = this.navTree.getDestination()) != null && (graphicPanelProducer = navigationDestination.getGraphicPanelProducer()) != null && (graphicPanel = graphicPanelProducer.getGraphicFor(navigationDestination, null, null)) != null) {
            this.borderedGraphicPanel = new BorderedPanel(graphicPanel, 3, 3, this.getBackground());
            this.add("DeviceGraphic", this.borderedGraphicPanel);
        }
    }

    protected void removeGraphicPanel() {
        if (this.borderedGraphicPanel != null) {
            this.remove(this.borderedGraphicPanel);
            Component component = this.borderedGraphicPanel.getContents();
            System.out.println("c is " + component);
            if (component instanceof GraphicPanel) {
                ((GraphicPanel)component).dispose();
            }
        }
    }

    protected void resetGraphicPanel() {
        this.removeGraphicPanel();
        this.setupGraphicPanel();
    }

    public void navPointSelected(NavigationPoint navigationPoint) {
        Object object;
        if (this.borderedGraphicPanel != null && (object = (GraphicPanel)this.borderedGraphicPanel.getContents()) != null) {
            ((GraphicPanel)object).deselectComponent();
        }
        object = navigationPoint.getDestination();
        this.navigateTo((NavigationDestination)object, navigationPoint.getNavContext());
    }

    public void navPointDeselected() {
        this.changeDestPanel(new NilDestination());
    }

    private synchronized void changeDestPanel(DestinationPanel destinationPanel) {
        Component component = this.destPanel.getComponent();
        component.setVisible(false);
        this.jdmDestPanel.remove(component);
        this.destPanel = destinationPanel;
        this.jdmDestPanel.add("Center", this.destPanel.getComponent());
        this.jdmDestPanel.setVisible(false);
        Rectangle rectangle = this.jdmDestPanel.getBounds();
        this.jdmDestPanel.setBounds(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        this.jdmDestPanel.invalidate();
        this.jdmDestPanel.validate();
        this.jdmDestPanel.setVisible(true);
        this.validate();
        this.invalidate();
    }

    public synchronized void navigationFolderExpanded(NavigationFolder navigationFolder) {
    }

    public synchronized void navigationFolderCollapsed(NavigationFolder navigationFolder) {
    }

    public void setIsApplication(boolean bl) {
        this.isApplication = bl;
    }

    public boolean getIsApplication() {
        return this.isApplication;
    }

    public synchronized void graphicNavigateTo(NavigationDestination navigationDestination, NavigationContext navigationContext, GraphicComponent graphicComponent) {
        GraphicPanel graphicPanel = (GraphicPanel)this.borderedGraphicPanel.getContents();
        graphicPanel.selectComponent(graphicComponent);
        this.hideFlyOver();
        this.navBrowser.deselectAll();
        this.navigateTo(navigationDestination, navigationContext);
    }

    private void setDestPanel(DestinationPanel destinationPanel) {
        this.destPanel = destinationPanel;
    }

    private DestinationPanel getDestPanel() {
        return this.destPanel;
    }

    private void setJdmDestPanel(Panel panel) {
        this.jdmDestPanel = panel;
    }

    private Panel getJdmDestPanel() {
        return this.jdmDestPanel;
    }

    private void setBorderedGraphicPanel(BorderedPanel borderedPanel) {
        this.borderedGraphicPanel = borderedPanel;
    }

    private BorderedPanel getBorderedGraphicPanel() {
        return this.borderedGraphicPanel;
    }

    protected void navigateTo(NavigationDestination navigationDestination, NavigationContext navigationContext) {
        if (this.navThread != null) {
            this.navThread.stopRmiSafe();
        }
        if (navigationDestination != null) {
            this.navThread = new NavigateToThread(this, navigationDestination, navigationContext);
            this.navThread.start();
        }
    }

    public void setGraphicPanel(GraphicPanel graphicPanel) {
        GraphicPanel graphicPanel2 = null;
        BorderedPanel borderedPanel = this.getBorderedGraphicPanel();
        if (borderedPanel != null) {
            graphicPanel2 = (GraphicPanel)borderedPanel.getContents();
        }
        if (graphicPanel != graphicPanel2) {
            borderedPanel.setContents(graphicPanel);
            this.setBorderedGraphicPanel(borderedPanel);
            borderedPanel.setVisible(false);
            Rectangle rectangle = borderedPanel.getBounds();
            borderedPanel.setBounds(rectangle.x, rectangle.y, rectangle.width + 300, rectangle.height + 300);
            borderedPanel.invalidate();
            borderedPanel.validate();
            borderedPanel.setVisible(true);
            this.invalidate();
            this.validate();
        }
    }

    public void checkDebugSwitch() {
        String string = this.getParameter(DebugKey);
        if (string != null && string.equals("yes")) {
            DebugSwitch = true;
        }
    }

    public void doLayoutDialog() {
        if (this.layoutDialog == null) {
            this.layoutDialog = new JdmLayoutDialog(this);
        }
        this.layoutDialog.show();
    }

    public void layoutDialogEnded() {
        this.layoutDialog = null;
    }

    public void doGraphicHelper() {
        if (this.graphicHelper == null && this.borderedGraphicPanel != null) {
            this.graphicHelper = new GraphicHelper(this, (GraphicPanel)this.borderedGraphicPanel.getContents());
            this.graphicHelper.show();
        }
    }

    public void graphicHelperEnded() {
        this.graphicHelper = null;
    }

    public void showHelp(HelpRef helpRef) {
        try {
            URL uRL = helpRef.getURL(this.getHelpBase(), Locale.getDefault());
            if (uRL != null) {
                if (this.getIsApplication()) {
                    try {
                        this.launchWebBrowser(uRL.toString());
                        return;
                    }
                    catch (Exception exception) {
                        MessageDialog messageDialog = new MessageDialog(this.getFrame(), myResources.getString("WebBrowserProb"), true);
                        messageDialog.show();
                        return;
                    }
                }
                this.getAppletContext().showDocument(uRL, "HELP");
                return;
            }
            System.out.println("No help for " + helpRef.toString());
            MessageDialog messageDialog = new MessageDialog(this.getFrame(), myResources.getString("WebBrowserProb"), true);
            messageDialog.show();
            return;
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            new MessageDialog(this.getFrame(), myResources.getString("HelpRef"), true);
            return;
        }
    }

    public void showMainHelp() {
        this.showHelp(new HelpRef(".", "toc.html"));
    }

    protected String getWebBrowser() {
        String string = System.getProperty(WebBrowserKey);
        if (string == null && this.properties != null) {
            string = (String)((Hashtable)this.properties).get(WebBrowserKey);
        }
        return string;
    }

    public void showHelpAboutDialog() {
        String string = (String)((Hashtable)this.properties).get(AboutTextPropName);
        String string2 = (String)((Hashtable)this.properties).get(AboutIconPropName);
        Image image = this.imageFrom(this, string2);
        int n = Integer.parseInt((String)((Hashtable)this.properties).get(AboutWidthPropName));
        int n2 = Integer.parseInt((String)((Hashtable)this.properties).get(AboutHeightPropName));
        AboutDialog aboutDialog = new AboutDialog(this.getFrame(), image, string);
        ((Component)aboutDialog).setBackground(this.getBackground());
        aboutDialog.setForeground(this.getForeground());
        aboutDialog.setTitle((String)((Hashtable)this.properties).get(AboutTitlePropName));
        ((Component)aboutDialog).setSize(n, n2);
        aboutDialog.show();
    }

    public void launchWebBrowser(String string) throws IOException, IllegalArgumentException {
        String string2 = this.getWebBrowser();
        if (string2 != null && string2.trim().length() > 0) {
            if (string.indexOf(32) >= 0 && string.indexOf(34) != 0) {
                string = "\"" + string + "\"";
            }
            String[] stringArray = new String[]{string2, string};
            Runtime.getRuntime().exec(stringArray);
            return;
        }
        throw new IllegalArgumentException("No Web Browser");
    }

    public Dimension getDefaultSize() {
        return defaultSize;
    }

    public PopupMenu getNewPopupMenu() {
        PopupMenu popupMenu = new PopupMenu();
        popupMenu.setName(BrowserPopupName);
        Menu menu = new Menu(BrowserApplet.messageText("Help"));
        MenuItem menuItem = new MenuItem(String.valueOf(BrowserApplet.messageText("Contents")) + "...");
        menuItem.addActionListener(new 1());
        menu.add(menuItem);
        MenuItem menuItem2 = new MenuItem(String.valueOf(BrowserApplet.messageText("About")) + "...");
        menuItem2.addActionListener(new 2());
        menu.add(menuItem2);
        popupMenu.add(menu);
        Menu menu2 = new Menu(BrowserApplet.messageText("View"));
        popupMenu.add(menu2);
        MenuItem menuItem3 = new MenuItem(BrowserApplet.messageText("Layout"));
        menuItem3.addActionListener(new 3());
        menu2.add(menuItem3);
        return popupMenu;
    }

    protected static String messageText(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.BrowserAppletResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private synchronized void showFlyOver(String string, Point point) {
        Point point2 = this.getLocationOnScreen();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        this.flyOver.setVisible(false);
        this.flyOver.setUp(string, point3, this.getSize(), this.getGraphics());
        this.flyOver.setVisible(true);
    }

    public synchronized void hideFlyOver() {
        if (this.flyOverTimer != null && this.flyOverTimer.isAlive()) {
            this.flyOverTimer.stop();
        }
        this.flyOver.setVisible(false);
    }

    public synchronized void setComponentWithFlyOver(GraphicComponent graphicComponent) {
        this.setComponentWithFlyOver(null, null);
    }

    public synchronized void setComponentWithFlyOver(GraphicComponent graphicComponent, Point point) {
        if (graphicComponent != null) {
            if (this.flyOver.isVisible()) {
                return;
            }
            if (this.flyOverTimer != null && this.flyOverTimer.isAlive()) {
                this.flyOverTimer.stop();
            }
            this.flyOverTimer = new FlyOverTimer(graphicComponent, point);
            this.flyOverTimer.start();
            return;
        }
        this.hideFlyOver();
    }

    final /* synthetic */ void access$0(DestinationPanel destinationPanel) {
        this.changeDestPanel(destinationPanel);
    }

    final /* synthetic */ BorderedPanel access$1() {
        return this.getBorderedGraphicPanel();
    }

    final /* synthetic */ void access$2(String string, Point point) {
        this.showFlyOver(string, point);
    }

    final /* synthetic */ void access$3() {
        this.navigateToInitialDest();
    }

    static {
        myResources = null;
        DefaultBackgroundColor = new Color(222, 220, 220);
        DefaultForegroundColor = new Color(0, 0, 0);
        DefaultAxisColor = Color.lightGray;
        DefaultSelListBackColor = SystemColor.text;
        DefaultSelListForeColor = SystemColor.textText;
        DefaultButtonForeground = SystemColor.controlText;
        DefaultButtonBackground = SystemColor.control;
        defaultSize = new Dimension(800, 600);
        AboutTextPropName = "helpAboutText";
        AboutIconPropName = "helpAboutIcon";
        AboutTitlePropName = "helpAboutTitle";
        AboutWidthPropName = "helpAboutWidth";
        AboutHeightPropName = "helpAboutHeight";
    }

    class CreateRestOfNavTreeThread
    extends Thread {
        public void run() {
            System.out.println("Getting rest of nav tree...");
            long l = System.currentTimeMillis();
            BrowserApplet.this.setFlyOverDelay(1000);
            BrowserApplet.this.getRestOfNavTree();
            long l2 = System.currentTimeMillis();
            System.out.println("Done getting rest of nav tree: " + (l2 - l) + " millis");
            BrowserApplet.this.setFlyOverDelay(400);
            BrowserApplet.this.access$3();
            BrowserApplet.this.setNavigationPopupEnabled(true);
        }

        CreateRestOfNavTreeThread() {
            BrowserApplet.this = BrowserApplet.this;
        }
    }

    class NavigateToThread
    extends Thread {
        BrowserApplet browserApplet;
        NavigationDestination dest;
        NavigationContext navContext;
        Object killLock = new Object();

        NavigateToThread(BrowserApplet browserApplet2, NavigationDestination navigationDestination, NavigationContext navigationContext) {
            BrowserApplet.this = BrowserApplet.this;
            this.browserApplet = browserApplet2;
            this.dest = navigationDestination;
            this.navContext = navigationContext;
        }

        public void run() {
            DestinationPanel destinationPanel = null;
            Object object = this.killLock;
            synchronized (object) {
                destinationPanel = this.dest.newPanel(this.browserApplet, this.navContext);
            }
            BrowserApplet.this.access$0(destinationPanel);
            object = this.dest.getGraphicPanelProducer();
            if (object != null) {
                GraphicPanel graphicPanel = null;
                BorderedPanel borderedPanel = this.browserApplet.access$1();
                if (borderedPanel != null) {
                    graphicPanel = (GraphicPanel)borderedPanel.getContents();
                }
                GraphicPanel graphicPanel2 = object.getGraphicFor(this.dest, graphicPanel, this.navContext);
                BrowserApplet.this.setGraphicPanel(graphicPanel2);
            }
        }

        public void stopRmiSafe() {
            Object object = this.killLock;
            synchronized (object) {
                this.stop();
                return;
            }
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserApplet.this.showMainHelp();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserApplet.this.showHelpAboutDialog();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BrowserApplet.this.doLayoutDialog();
        }

        /* synthetic */ 3() {
        }
    }

    class FlyOverTimer
    extends Thread {
        Point mousePoint;
        GraphicComponent comp;

        public FlyOverTimer(GraphicComponent graphicComponent, Point point) {
            BrowserApplet.this = BrowserApplet.this;
            this.comp = graphicComponent;
            this.mousePoint = point;
            this.setPriority(this.getPriority() - 1);
        }

        public void run() {
            try {
                Thread.sleep(BrowserApplet.this.flyOverDelay);
                Point point = this.comp.getLocationOnScreen();
                Point point2 = new Point(point.x + this.mousePoint.x, point.y + this.mousePoint.y);
                this.setPriority(10);
                BrowserApplet.this.access$2(this.comp.getFlyOver().getText(), point2);
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
    }
}

